import { CstNode, IToken } from 'chevrotain';

export interface KeyNode extends CstNode {
   children: {
      Value: IToken[];
   };
}

export interface OperatorNode extends CstNode {
   children: {
      Equal?: IToken[];
      Grep?: IToken[];
      NotEqual?: IToken[];
      NotGrep?: IToken[];
   };
}

export interface ValueNode extends CstNode {
   children: {
      QuotedValue: IToken[];
      Value: IToken[];
   };
}

export interface ValuesNode extends CstNode {
   children: {
      value: ValueNode[];
   };
}

export interface ExpressionNode extends CstNode {
   children: {
      key: KeyNode[];
      operator: OperatorNode[];
      values: ValuesNode[];
   };
}

export interface QueryNode extends CstNode {
   children: {
      expression: ExpressionNode[];
   };
}
