import { Operator } from '../../api/models/Operator';

import { cleanupExpressions } from './helpers';

describe('QueryProvider helpers', () => {
   describe('cleanupExpressions', () => {
      it('should ignore empty', () => {
         expect(
            cleanupExpressions([
               { key: 'key1', operator: Operator.Equal, values: [] },
               { key: 'key2', operator: Operator.Equal, values: ['value2'] },
            ]),
         ).toEqual([{ key: 'key2', operator: Operator.Equal, values: ['value2'] }]);
      });

      it('should merge equal keys', () => {
         expect(
            cleanupExpressions([
               { key: 'key', operator: Operator.Equal, values: ['value1'] },
               { key: 'key', operator: Operator.Equal, values: ['value2'] },
               { key: 'key2', operator: Operator.Equal, values: ['value3'] },
            ]),
         ).toEqual([
            { key: 'key', operator: Operator.Equal, values: ['value1', 'value2'] },
            { key: 'key2', operator: Operator.Equal, values: ['value3'] },
         ]);
      });
   });
});
