import type { IRange } from 'monaco-editor';

import { Operator } from '../../api/models/Operator';

export enum FieldType {
   String = 'String',
   Number = 'Number',
   Object = 'Object',
}

export interface QueryField {
   keyType: string;
   name: string;
   operators: Operator[];
   type: FieldType;
}

/**
 * All supported places in query to show suggestions
 */
export enum SuggestCase {
   AfterComma = 'AfterComma',
   AfterKey = 'AfterKey',
   AfterOperator = 'AfterOperator',
   AfterSemicolon = 'AfterSemicolon',
   Empty = 'Empty',
   InEmptyQuotes = 'InEmptyQuotes',
   InQuotedValue = 'InQuotedValue',
   InTheKey = 'InTheKey',
   InTheOperator = 'InTheOperator',
   InsideValue = 'InsideValue',
   NoSuggestions = 'NoSuggestions',
}

export interface SuggestRequest {
   case: SuggestCase;
   fieldName?: string;
   query: string;
   range: IRange;
   type: 'key' | 'value' | 'empty';
}
