import { SuggestCase, SuggestRequest } from './models';
import { getSuggestRequest } from './suggestVisitor';

describe('log-page/query/suggestVisitor', () => {
   function test(query: string) {
      return getSuggestRequest(query.replace('|', ''), {
         column: query.indexOf('|') + 1, // column starts with 1, not 0 as usual
         lineNumber: 1,
      });
   }

   it(SuggestCase.AfterComma, () => {
      expect(test('status=404; method=GET,|')).toEqual({
         case: SuggestCase.AfterComma,
         type: 'value',
         fieldName: 'method',
         query: '',
         range: {
            endColumn: 24,
            endLineNumber: 1,
            startColumn: 24,
            startLineNumber: 1,
         },
      } as SuggestRequest);
   });

   it(SuggestCase.AfterKey, () => {
      expect(test('meth|')).toEqual({
         case: SuggestCase.AfterKey,
         type: 'key',
         fieldName: undefined,
         query: 'meth',
         range: {
            endColumn: 4,
            endLineNumber: 1,
            startColumn: 1,
            startLineNumber: 1,
         },
      } as SuggestRequest);

      expect(test('status=404; meth|')).toEqual({
         case: SuggestCase.AfterKey,
         type: 'key',
         fieldName: undefined,
         query: 'meth',
         range: {
            endColumn: 16,
            endLineNumber: 1,
            startColumn: 13,
            startLineNumber: 1,
         },
      } as SuggestRequest);
   });

   it(SuggestCase.AfterOperator, () => {
      expect(test('method=|')).toEqual({
         case: SuggestCase.AfterOperator,
         type: 'value',
         fieldName: 'method',
         query: '',
         range: {
            startColumn: 8,
            endLineNumber: 1,
            endColumn: 8,
            startLineNumber: 1,
         },
      } as SuggestRequest);
   });

   it(SuggestCase.AfterSemicolon, () => {
      expect(test('method=GET; |')).toEqual({
         case: SuggestCase.AfterSemicolon,
         type: 'key',
         fieldName: undefined,
         query: '',
         range: {
            startColumn: 13,
            endLineNumber: 1,
            endColumn: 13,
            startLineNumber: 1,
         },
      } as SuggestRequest);
   });

   it(SuggestCase.Empty, () => {
      expect(test('|')).toEqual({
         case: SuggestCase.Empty,
         type: 'key',
         fieldName: undefined,
         query: '',
         range: {
            startColumn: 1,
            endLineNumber: 1,
            endColumn: 1,
            startLineNumber: 1,
         },
      } as SuggestRequest);
   });

   it.skip(SuggestCase.InEmptyQuotes, () => {
      console.log('skip');
   });

   it.skip(SuggestCase.InQuotedValue, () => {
      console.log('skip');
   });

   it(SuggestCase.InTheKey, () => {
      expect(test('met|hod')).toEqual({
         case: SuggestCase.InTheKey,
         type: 'key',
         fieldName: undefined,
         query: 'met',
         range: {
            endColumn: 6,
            endLineNumber: 1,
            startColumn: 1,
            startLineNumber: 1,
         },
      } as SuggestRequest);

      expect(test('status=404; met|hod')).toEqual({
         case: SuggestCase.InTheKey,
         type: 'key',
         fieldName: undefined,
         query: 'met',
         range: {
            endColumn: 18,
            endLineNumber: 1,
            startColumn: 13,
            startLineNumber: 1,
         },
      } as SuggestRequest);
   });

   it.skip(SuggestCase.InTheOperator, () => {
      console.log('skip');
   });

   it.skip(SuggestCase.InsideValue, () => {
      console.log('skip');
   });

   it.skip(SuggestCase.NoSuggestions, () => {
      console.log('skip');
   });
});
