import * as React from 'react';

import { QueryProvider } from './query/provider/QueryProvider';

export interface LogPageContextValue {
   queryProvider: QueryProvider;
}

const LogPageContext = React.createContext<LogPageContextValue | null>(null);

export const LogPageProvider: React.FC<{ value: LogPageContextValue }> = ({ children, value }) => (
   <LogPageContext.Provider value={value}>{children}</LogPageContext.Provider>
);

export function useLogPageContext() {
   const context = React.useContext(LogPageContext);
   if (context === undefined) {
      throw new Error('useLogPageContext must be used within a LogPageProvider');
   }
   return context;
}
