import { Meta, Story } from '@storybook/react';
import * as React from 'react';

import { DateCell } from './DateCell';

const rowEntry = {
   regular: new Date(),
   string: '2021-11-22',
   empty: null,
};

const Template: Story<{ column: string }> = ({ column }) => <DateCell rowEntry={rowEntry} columnName={column} />;

export const Default = Template.bind({});
Default.args = { column: 'regular' };

export const String = Template.bind({});
String.args = { column: 'string' };

export const Empty = Template.bind({});
Empty.args = { column: 'empty' };

export default {
   title: 'smart-table/cells/DateCell',
} as Meta;
