import { classNames, EMPTY_VALUE, formatDate } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { CellProps } from '../../models';

import classes from './DateCell.module.css';

export const DateCell: React.FC<CellProps> = React.memo(({ rowEntry, columnName }) => {
   const date = rowEntry[columnName];

   return (
      <div className={classNames(classes.wrapper)}>
         {date ? formatDate(date instanceof Date ? date : new Date(date), 'short') : EMPTY_VALUE}
      </div>
   );
});

DateCell.displayName = 'DateCell';
