import { Json } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useMemo } from 'react';

import { CellProps } from '../../models';
import classes from '../PreCell/PreCell.module.css';

export const JsonCell: React.FC<CellProps> = React.memo(({ rowEntry, columnName }) => {
   const obj = useMemo(() => {
      const val = rowEntry[columnName];

      return typeof val === 'string' && val[0] === '{' ? JSON.parse(val) : val;
   }, [rowEntry, columnName]);

   return <Json className={classes.pre} obj={obj} />;
});

JsonCell.displayName = 'JsonCell';
