import { Meta, Story } from '@storybook/react';
import * as React from 'react';

import { NumberCell } from './NumberCell';

const rowEntry = {
   number: 123,
   empty: null,
};
const Template: Story<{ column: string }> = ({ column }) => <NumberCell rowEntry={rowEntry} columnName={column} />;

export const Default = Template.bind({});
Default.args = { column: 'number' };

export const Empty = Template.bind({});
Empty.args = { column: 'empty' };

export default {
   title: 'smart-table/cells/NumberCell',
} as Meta;
