import { formatNumber } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { CellProps } from '../../models';

import classes from './NumberCell.module.css';

export const NumberCell: React.FC<CellProps> = React.memo(({ columnName, rowEntry }) => {
   const number = rowEntry[columnName];

   return <div className={classes.wrapper}>{typeof number === 'number' ? formatNumber(number) : number}</div>;
});

NumberCell.displayName = 'NumberCell';
