import { EMPTY_VALUE } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { CellProps } from '../../models';

import classes from './PreCell.module.css';

export const PreCell: React.FC<CellProps> = React.memo(({ rowEntry, columnName }) => {
   const value = rowEntry[columnName];

   return <pre className={classes.pre}>{value ?? EMPTY_VALUE}</pre>;
});

PreCell.displayName = 'PreCell';
