import { Meta, Story } from '@storybook/react';
import * as React from 'react';

import { StringCell } from './StringCell';

const Template: Story<{ value: string | null }> = ({ value }) => (
   <StringCell rowEntry={{ value }} columnName={'value'} />
);

export const Default = Template.bind({});
Default.args = { value: 'long text\nlong text' };

export const Empty = Template.bind({});
Empty.args = { value: null };

export default {
   title: 'smart-table/cells/StringCell',
} as Meta;
