import { RadioButton } from '@yandex-cloud/uikit';
import { classNames } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { enumToOptions } from '../../helpers/enumToOptions';
import { useSmartTableContext } from '../../hooks/useSmartTableContext';
import { ColumnPreset } from '../../models/ColumnPreset';

import classes from './ColumnPresets.module.css';

const columnPresetOptions = enumToOptions(ColumnPreset);

export interface ColumnPresetsProps {
   className?: string;
}

export const ColumnPresets: React.FC<ColumnPresetsProps> = React.memo(({ className }) => {
   const { columnPreset, setColumnPreset } = useSmartTableContext();

   return (
      <div className={classNames(classes.wrapper, className)}>
         {/* eslint-disable-next-line jsx-a11y/label-has-associated-control */}
         <label>Columns:</label>
         <RadioButton
            options={columnPresetOptions}
            value={columnPreset}
            onUpdate={setColumnPreset as (p: string) => void}
         />
      </div>
   );
});

ColumnPresets.displayName = 'ColumnPresets';
