import * as React from 'react';
import { useCallback } from 'react';

import { useSmartTableContext } from '../../hooks/useSmartTableContext';
import { FilterProps, PlainObject } from '../../models';

export interface FilterWrapperProps<V> {
   component: React.FC<FilterProps<V>>;
   defaultValue: V;
   internalProps?: any;
   name: string;

   getValueFromUrlParams?(urlParams: PlainObject, filterName: string): V;

   setUrlParamsFromValue?(v: V): PlainObject;
}

export function Filter<V>({ name, component: FilterComponent, internalProps }: FilterWrapperProps<V>) {
   const {
      filtersHook: { getFilter, setFilter, submitFilters },
   } = useSmartTableContext();

   const onUpdate = useCallback(
      (v: any, submit?: false) => {
         setFilter(name, v);

         if (submit) {
            submitFilters();
         }
      },
      [name, setFilter, submitFilters],
   );

   return <FilterComponent value={getFilter(name)} onUpdate={onUpdate} internalProps={internalProps} />;
}

Filter.displayName = 'SmartTable.Filter';
