import { Button } from '@yandex-cloud/uikit';
import * as React from 'react';
import { useCallback } from 'react';

import {
   getAbsoluteDateFromRelative,
   intervalFilterName,
   IntervalValue,
} from '../../../log-page/filters/IntervalFilter/IntervalFilter';

import { useSmartTableContext } from '../../hooks/useSmartTableContext';

export const FilterButtons: React.FC = React.memo(() => {
   const {
      filtersHook: { clearFilters, submitFilters, setFilter, filters },
   } = useSmartTableContext();

   const interval: IntervalValue = filters[intervalFilterName];

   const handleSubmit = useCallback(() => {
      // обновляем интервал на актуальный, если relative даты
      if (interval.from?.relative || interval.to?.relative) {
         const newInterval = { ...interval };

         if (newInterval.from?.relative) {
            newInterval.from.absolute = getAbsoluteDateFromRelative(newInterval.from.relative);
         }

         if (newInterval.to?.relative) {
            newInterval.to.absolute = getAbsoluteDateFromRelative(newInterval.to.relative);
         }

         setFilter(intervalFilterName, newInterval);
      }

      submitFilters();
   }, [interval, setFilter, submitFilters]);

   return (
      <>
         <Button view={'action'} onClick={handleSubmit}>
            Search
         </Button>
         <Button view={'outlined'} onClick={clearFilters}>
            Reset
         </Button>
      </>
   );
});

FilterButtons.displayName = 'FilterButtons';
