import { classNames } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { DataFilters } from '../../models';

import classes from './Filters.module.css';

const data = {
   [DataFilters.name]: DataFilters.value,
};

export interface FiltersProps {
   className?: string;
}

export const Filters: React.FC<FiltersProps> = React.memo(({ className, children }) => (
   <div className={classNames(classes.wrapper, className)} {...data}>
      {children}
   </div>
));

Filters.displayName = 'SmartTable.Filters';
