import { Meta, Story } from '@storybook/react';
import * as React from 'react';

import { ExpandableTable } from './ExpandableTable';

const data = [
   { id: 1, text: 'Hello' },
   { id: 2, text: 'World' },
];

const columns = [{ id: 'id' }, { id: 'text' }];

const Template: Story<{}> = () => (
   <ExpandableTable
      data={data}
      columns={columns}
      expandedRowClassName={'expanded'}
      secondRowClassName={'secondRow'}
      renderSecondRow={(item: any) => <div style={{ textAlign: 'center' }}>{item.text.toLowerCase()}</div>}
   />
);

export const Default = Template.bind({});
Default.args = {};

export default {
   title: 'smart-table/ExpandableTable',
} as Meta;
