import { faSortAmountDown } from '@fortawesome/free-solid-svg-icons/faSortAmountDown';
import { faSortAmountDownAlt } from '@fortawesome/free-solid-svg-icons/faSortAmountDownAlt';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { TableColumnConfig, TableDataItem, TableProps } from '@yandex-cloud/uikit';
import { memoize } from 'lodash';
import * as React from 'react';

import { Order } from '../../../models';

import classes from './withOrderColumn.module.css';

interface WithOrderColumnProps {
   columnWithOrder: string;
   order: Order;

   onOrderToggle(): void;
}

// eslint-disable-next-line @typescript-eslint/no-empty-interface
interface WithOrderColumnState {}

export function withOrderColumn<I extends TableDataItem, E extends {} = {}>(
   TableComponent: React.ComponentType<TableProps<I> & E>,
): React.ComponentType<TableProps<I> & WithOrderColumnProps & E> {
   return class extends React.Component<TableProps<I> & WithOrderColumnProps & E, WithOrderColumnState> {
      private enhanceColumns = memoize((columns: TableColumnConfig<I>[]) =>
         columns.map(column => {
            if (column.id !== this.props.columnWithOrder) {
               return column;
            }

            return {
               ...column,
               name: () => {
                  const { order, onOrderToggle } = this.props;

                  return (
                     <div onClick={onOrderToggle} role={'button'} tabIndex={0} className={classes.orderColumnHeader}>
                        {column.name ?? column.id}

                        <span className={classes.orderIcon} title={order}>
                           {order === Order.ASC ? (
                              <FontAwesomeIcon icon={faSortAmountDownAlt} fixedWidth={true} />
                           ) : (
                              <FontAwesomeIcon icon={faSortAmountDown} fixedWidth={true} />
                           )}
                        </span>
                     </div>
                  );
               },
            };
         }),
      );

      public render() {
         const { columns, ...restTableProps } = this.props;

         return (
            <TableComponent
               {...(restTableProps as Omit<TableProps<I>, 'columns'> & E)}
               columns={this.enhanceColumns(columns)}
            />
         );
      }
   };
}
