import { YCSelect, YCSelectItem } from '@yandex-data-ui/common';
import { YCSelectProps } from '@yandex-data-ui/common/build/esm/components/YCSelect/YCSelect';
import * as React from 'react';
import { useCallback } from 'react';

import { LIMIT_OPTIONS } from '../../constants';
import { FilterProps } from '../../models';

import classes from './LimitFilter.module.css';

const limitOptions: YCSelectItem[] = LIMIT_OPTIONS.map(v => ({ value: v.toString(), title: v.toString() }));

export const LimitFilter: React.FC<FilterProps<number, YCSelectProps<'single'>>> = ({
   value,
   onUpdate: onLimitUpdate,
   internalProps,
}) => {
   const onUpdate = useCallback((v: string) => onLimitUpdate(parseInt(v, 10), true), [onLimitUpdate]);

   return (
      <div className={classes.wrapper}>
         {/* eslint-disable-next-line jsx-a11y/label-has-associated-control */}
         <label>Limit:</label>
         <YCSelect
            {...internalProps}
            allowEmptyValue={false}
            className={classes.limitInput}
            items={limitOptions}
            onUpdate={onUpdate}
            placeholder={'Limit'}
            showSearch={false}
            type={YCSelect.SINGLE}
            value={value?.toString()}
         />
      </div>
   );
};
