import { nestedToPlain, plainToNested } from './nestedToPlain';

describe('smart-table/helpers/nestedToPlain', () => {
   it('should nestedToPlain', () => {
      expect(
         nestedToPlain({
            x: { y: 2, z: 3, a: [1, 2, 3] },
            y: {},
         }),
      ).toEqual({
         'x.y': 2,
         'x.z': 3,
         'x.a': [1, 2, 3],
         'y': {},
      });
   });

   it('should plainToNested', () => {
      expect(
         plainToNested({
            'x.y': 2,
            'x.z': 3,
            'y': {},
         }),
      ).toEqual({
         x: { y: 2, z: 3 },
         y: {},
      });
   });
});
