import { setIn } from 'formik';

import { PlainObject } from '../models';

function isObject(obj: any): boolean {
   return obj && obj.constructor === Object;
}

export function nestedToPlain(obj: PlainObject): PlainObject {
   const result: PlainObject = {};

   function walk(internalObj: PlainObject, parent?: string) {
      const entries = Object.entries(internalObj);
      if (entries.length > 0) {
         for (const [field, value] of entries) {
            if (isObject(value)) {
               walk(value, field);
            } else {
               result[`${parent ? `${parent}.` : ''}${field}`] = value;
            }
         }
      } else if (parent) {
         result[parent] = internalObj;
      }
   }

   walk(obj);

   return result;
}

export function plainToNested(obj: PlainObject): PlainObject {
   let result: PlainObject = {};

   for (const [field, value] of Object.entries(obj)) {
      result = setIn(result, field, value);
   }

   return result;
}
