import { isEmpty, isEqual } from '@yandex-infracloud-ui/libs';

import { PlainObject } from '../models';

export function omitEmptyOrDefault<T = PlainObject>(defaults: T, obj: T): Partial<T> {
   const result: Partial<T> = {};

   for (const [field, value] of Object.entries(obj)) {
      if (!isEmpty(value) && !isEqual(value, (defaults as any)[field])) {
         (result as any)[field] = value;
      }
   }

   return result;
}
