import * as React from 'react';
import { DependencyList, useEffect, useRef } from 'react';

export function useEffectSkipFirst(cb: React.EffectCallback, deps?: DependencyList) {
   const hasAlreadyRendered = useRef(false);
   useEffect(() => {
      if (!hasAlreadyRendered.current) {
         hasAlreadyRendered.current = true;
         return () => undefined;
      }

      return cb();
      // eslint-disable-next-line react-hooks/exhaustive-deps
   }, deps);
}
