import * as React from 'react';

import { GetItemsResponse } from '../models';
import { ColumnPreset } from '../models/ColumnPreset';

import { FiltersHook } from './useSmartTableFilters';

export interface SmartTableContextValue {
   columnPreset: ColumnPreset;
   filtersHook: FiltersHook;
   isLoading: boolean;
   response: GetItemsResponse | undefined;

   setColumnPreset(p: ColumnPreset): void;

   toggleOrder(): void;

   handleLoadMore(): void;
}

const SmartTableContext = React.createContext<SmartTableContextValue | null>(null);

export const SmartTableProvider: React.FC<{ value: SmartTableContextValue }> = ({ children, value }) => (
   <SmartTableContext.Provider value={value}>{children}</SmartTableContext.Provider>
);

export function useSmartTableContext() {
   const context = React.useContext(SmartTableContext);
   if (!context) {
      throw new Error('useSmartTableContext must be used within a SmartTableProvider');
   }
   return context;
}
