import { InfraBuzzer } from '@yandex-data-ui/infra-buzzer';
import { Event } from '@yandex-data-ui/infra-buzzer/build/esm/utils/types';
import { isEmpty } from '@yandex-infracloud-ui/libs';
import React, { useState } from 'react';

import { Config } from '../../../services/Config';

import classes from './BuzzerEventWarning.module.css';

export const BuzzerEventWarning: React.FC = React.memo(() => {
   const [events, setEvents] = useState<Event[] | undefined>(undefined);

   const config = Config.getInfraBuzzerConfig();

   if (!config.enabled) {
      return null;
   }

   return (
      <div className={events && !isEmpty(events) ? undefined : classes.hidden}>
         <div className={classes.ongoingEventsWarning}>
            <div>Check the buzzer. The error can be connected to ongoing events.</div>

            <InfraBuzzer
               subscribeTo={config.subscribeTo}
               environment={config.environment}
               onEventsUpdate={({ ongoingEvents }) => {
                  setEvents(ongoingEvents);
               }}
            />
         </div>
      </div>
   );
});

BuzzerEventWarning.displayName = 'YpErrorPlate';
