import { TIMES_IN_MS, UpdateTimerMode, useUpdateTimer } from '@yandex-infracloud-ui/libs';
import React, { useCallback, useState } from 'react';

interface Props {
   timestamp: number;
}

export const SecondTimer: React.FC<Props> = React.memo(({ timestamp }) => {
   const now = Date.now();
   const [, setUpdateFlag] = useState(true);
   const handleRefresh = useCallback(() => setUpdateFlag(e => !e), []);

   useUpdateTimer({
      callback: handleRefresh,
      slow: TIMES_IN_MS.Second,
      fast: TIMES_IN_MS.Second,
      mode: UpdateTimerMode.Slow,
   });

   const diffSeconds = Math.ceil((now - timestamp) / TIMES_IN_MS.Second);

   return <span>{diffSeconds}</span>;
});

SecondTimer.displayName = 'SecondTimer';
