import { Collapse } from '@yandex-data-ui/common';
import { DISMISS_REASON, IModalProps, Json, ModalLayout } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';

import { RequestTimeoutItem } from '../../../models/api';
import { BuzzerEventWarning } from '../BuzzerEventWarning/BuzzerEventWarning';

import classes from './TimeoutModal.module.css';

interface Props extends IModalProps<void> {
   requests: RequestTimeoutItem[];
}

export const TimeoutModal: React.FC<Props> = React.memo(({ requests, ok, cancel }) => {
   const handleOk = useCallback(() => ok(), [ok]);
   const handleDismiss = useCallback(() => cancel(DISMISS_REASON), [cancel]);

   return (
      <ModalLayout title={'Requests timeout'} onDismiss={handleDismiss} onOk={handleOk} showFooter={false}>
         <BuzzerEventWarning />
         {requests.map(request => {
            const title = (
               <div className={classes.url} title={request.url}>
                  {request.url}
               </div>
            );
            return (
               <Collapse title={title}>
                  <Json obj={request.requestData} />
               </Collapse>
            );
         })}
      </ModalLayout>
   );
});

TimeoutModal.displayName = 'TimeoutModal';
