import { DISMISS_REASON, IModalProps, ModalLayout } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';

import { getYpDefaultErrorMessage } from '../../../models/api';
import { NetworkError, NetworkRequest } from '../../../redux/slices/network/model';
import { YpErrorPlate } from '../YpErrorPlate/YpErrorPlate';

import classes from './YpErrorModal.module.css';

interface Props extends IModalProps<void> {
   error: NetworkError;
   request?: NetworkRequest;
}

export const YpErrorModal: React.FC<Props> = React.memo(({ error, request, ok, cancel }) => {
   const handleOk = useCallback(() => ok(), [ok]);
   const handleDismiss = useCallback(() => cancel(DISMISS_REASON), [cancel]);

   const defaultMessage = request ? getYpDefaultErrorMessage(request) : null;

   return (
      <ModalLayout
         title={`${defaultMessage ? `${defaultMessage}: ` : ''}YP Api error`}
         onDismiss={handleDismiss}
         onOk={handleOk}
         showFooter={false}
      >
         <div className={classes.layout}>
            <YpErrorPlate error={error} request={request} />
         </div>
      </ModalLayout>
   );
});

YpErrorModal.displayName = 'YpErrorModal';
