import { modalService, useDismounted } from '@yandex-infracloud-ui/libs';
import { useCallback } from 'react';
import { takeUntil } from 'rxjs/operators';

import { NetworkError, NetworkRequest } from '../../../redux/slices/network/model';
import { YpErrorModal } from '../YpErrorModal/YpErrorModal';

interface Props {
   error: NetworkError;
   request?: NetworkRequest;
   className?: string;
}

export function useYpErrorModal(props: Props) {
   const dismounted = useDismounted();
   const onOpenModal = useCallback(() => {
      modalService.open(YpErrorModal, props).pipe(takeUntil(dismounted)).subscribe();
   }, [props, dismounted]);

   return onOpenModal;
}
