import { faExclamationTriangle } from '@fortawesome/free-solid-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { ClipboardButton } from '@yandex-cloud/uikit';
import { Collapse } from '@yandex-data-ui/common';
import { classNames, Json } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { NetworkYpErrorData } from '../../../models/api';
import { NetworkError, NetworkRequest } from '../../../redux/slices/network/model';
import { YtError } from '../../common';
import { BuzzerEventWarning } from '../BuzzerEventWarning/BuzzerEventWarning';

import classes from './YpErrorPlate.module.css';

interface Props {
   error: NetworkError;
   request?: NetworkRequest;
   className?: string;
}

export const YpErrorPlate: React.FC<Props> = React.memo(({ error, request, className }) => {
   const data = error.error.data as NetworkYpErrorData | undefined;
   const message = data?.ytMessage ?? error.message ?? error.error.body;
   return (
      <div className={classNames(classes.plate, className)}>
         <div className={classes.header}>
            <FontAwesomeIcon icon={faExclamationTriangle} size={'lg'} fixedWidth={true} className={classes.icon} />
            <div>{message}</div>
         </div>
         <BuzzerEventWarning />
         <div>
            {data && data.ytError && <YtError error={data.ytError} />}
            {request && (
               <>
                  {request.url && (
                     <div className={classes.url}>
                        Url: <em>{request.url}</em> <ClipboardButton text={request.url} size={14} />
                     </div>
                  )}
                  {request.data && (
                     <Collapse title={<span>request params</span>} titleSize={'s'} arrowView={'button'}>
                        <div className={classes.params}>
                           <Json obj={request.data} />
                        </div>
                     </Collapse>
                  )}
               </>
            )}
         </div>
      </div>
   );
});

YpErrorPlate.displayName = 'YpErrorPlate';
