import React from 'react';

import { faExclamationTriangle } from '@fortawesome/free-solid-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Button } from '@yandex-cloud/uikit';

import { getYpDefaultErrorMessage, NetworkYpErrorData } from '../../../models/api';
import { NetworkError, NetworkRequest } from '../../../redux/slices/network/model';
import { useYpErrorModal } from '../YpErrorModal/useYpErrorModal';

import classes from './YpErrorTooltip.module.css';

interface Props {
   error: NetworkError;
   request?: NetworkRequest;
   className?: string;
}

export const YpErrorTooltip: React.FC<Props> = React.memo(({ error, request, className }) => {
   const data = error.error.data as NetworkYpErrorData | undefined;
   const message = data?.ytMessage ?? error.message ?? error.error.body;

   const onOpenModal = useYpErrorModal({ error, request, className });

   const defaultMessage = request && getYpDefaultErrorMessage(request);

   return (
      <div className={classes.tooltip}>
         <div className={classes.header}>
            <FontAwesomeIcon icon={faExclamationTriangle} size={'lg'} fixedWidth={true} className={classes.icon} />
            <div className={classes.message}>
               {defaultMessage && `${defaultMessage}: `}
               {message}
            </div>
            <Button onClick={onOpenModal}>Show more</Button>
         </div>
      </div>
   );
});

YpErrorTooltip.displayName = 'YpErrorTooltip';
