import { object, text, withKnobs } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import * as React from 'react';
import { useEffect, useState } from 'react';

import { StageLogsProvider } from './provider/StageLogsProvider';
import { StageLogsQueryInput } from './StageLogsQueryInput';

const Component = (props: any) => {
   const [query, setQuery] = useState(props.query);

   useEffect(() => {
      setQuery(props.query);
   }, [props.query]);

   return <StageLogsQueryInput query={query} provider={props.provider} onChange={value => setQuery(value)} />;
};

export const withProvider = () => {
   const query = text('Query', 'a=value b=value2');
   const context = object('Context', {
      deployUnitId: 'torkve-test-deploy-unit-2-0',
      order: 'DESC',
      projectId: 'UNKNOWN',
      stageId: 'torkve-test-logs',
   });

   return <Component query={query} provider={new StageLogsProvider(context)} />;
};

export default {
   decorators: [withKnobs],
   parameters: { knobs: { escapeHTML: false } },
   title: 'components/query-inputs/StageLogsQueryInput',
} as Meta;
