import { QueryInput } from '@yandex-infracloud-ui/query-input';

import * as React from 'react';
import { SFC } from 'react';

import { lang } from '../languages/KeyValueLanguage';
import { theme } from '../themes/KeyValueTheme';

import { StageLogsProvider } from './provider/StageLogsProvider';

interface StageLogsQueryInputProps {
   onChange?: (value?: string) => void;
   query: string;
   provider: StageLogsProvider;
}

export const StageLogsQueryInput: SFC<StageLogsQueryInputProps> = props => (
   <QueryInput
      query={props.query}
      onChange={props.onChange}
      rows={2}
      provider={props.provider}
      lang={lang}
      theme={theme}
      placeholder={'Search parameters'}
   />
);
