import { Lexer } from 'chevrotain';

import { CurrentTokenInterpreter } from './CurrentTokenInterpreter';
import { queryParser } from './QueryParser';
import { tokens } from './tokens';

const QueryLexer = new Lexer(tokens);

describe('CurrentTokenInterpreter', () => {
   const tokenator = new CurrentTokenInterpreter();
   const queryString = 'a="value"; c!=value2; d=value3, value4; e="value 5", value6;';
   queryParser.input = QueryLexer.tokenize(queryString).tokens;
   const query = queryParser.query();

   it('should match key token', () => {
      expect(tokenator.visit(query, { lineNumber: 1, column: 1 })).toEqual({
         key: 'a',
         type: 'KEY',
         value: 'a',

         endColumn: 1,
         endLine: 1,
         startColumn: 1,
         startLine: 1,
      });

      expect(tokenator.visit(query, { lineNumber: 1, column: 13 })).toEqual({
         key: 'c',
         type: 'KEY',
         value: 'c',

         endColumn: 12,
         endLine: 1,
         startColumn: 12,
         startLine: 1,
      });
   });
});
