import { Lexer } from 'chevrotain';
import { QueryParser } from './QueryParser';
import { tokens } from './tokens';

const QueryLexer = new Lexer(tokens);

describe('QueryParser', () => {
   const queryParser = new QueryParser();

   it('should be empty', () => {
      const queryString = '';
      queryParser.input = QueryLexer.tokenize(queryString).tokens;
      const query = queryParser.query();

      expect(query.name).toBe('query');
      expect(query.children).toEqual({});
   });

   it('should contain expression', () => {
      const queryString = 'a=value';
      queryParser.input = QueryLexer.tokenize(queryString).tokens;
      const query = queryParser.query();

      expect(query.children.hasOwnProperty('expression')).toBe(true);
   });

   it('should be invalid', () => {
      const queryString = '?';
      queryParser.input = QueryLexer.tokenize(queryString).tokens;
      const query = queryParser.query();

      expect(query).toBe(undefined);
   });
});
