import { Position } from '@yandex-infracloud-ui/query-input';
import { CstParser } from 'chevrotain';

import { matchLocation } from './matchLocation';
import { Comma, Equal, ExpressionSeparator, NotEqual, QuotedValue, tokens, Value } from './tokens';

export class QueryParser extends CstParser {
   private operator = this.RULE('operator', () => {
      this.OR([{ ALT: () => this.CONSUME(Equal) }, { ALT: () => this.CONSUME(NotEqual) }]);
   });

   private value = this.RULE('value', () => {
      this.OR([{ ALT: () => this.CONSUME(Value) }, { ALT: () => this.CONSUME(QuotedValue) }]);
   });

   // trailing comma support
   private values = this.RULE('values', () => {
      this.OPTION(() => {
         this.SUBRULE(this.value);
      });
      this.MANY(() => {
         this.CONSUME(Comma);
         this.SUBRULE2(this.value);
      });
      this.MANY2(() => {
         this.CONSUME2(Comma);
      });
   });

   private expression = this.RULE('expression', () => {
      this.CONSUME(Value);
      this.SUBRULE(this.operator);
      this.SUBRULE(this.values);
      this.OPTION(() => {
         // this.SUBRULE(this.expression);
         this.CONSUME(ExpressionSeparator);
      });
   });

   public query = this.RULE('query', () => {
      this.MANY(() => {
         this.SUBRULE(this.expression);
      });
   });

   constructor() {
      super(tokens, {
         nodeLocationTracking: 'full',
      });
      this.performSelfAnalysis();
   }

   public getToken(position: Position) {
      return this.input.find(token => matchLocation(token, position));
   }
}

export const queryParser = new QueryParser();
export const VisitorConstructor = queryParser.getBaseCstVisitorConstructor();
