import { QueryNode } from './nodes';
import { QueryInterpreter } from './QueryInterpreter';

interface ValueList {
   values: string[];
   selectType: 'INCLUDE' | 'EXCLUDE';
}

interface UserField {
   path: string;
   values: string[];
   selectType: 'INCLUDE' | 'EXCLUDE';
}

export class RequestInterpreter extends QueryInterpreter {
   public query(ctx: QueryNode) {
      if (!ctx.expression) {
         return {};
      }

      const { fields, userFields } = ctx.expression.reduce(
         (acc, item) => {
            const { key, values, selectType } = this.visit(item);

            if (key.startsWith('context.')) {
               const path = key.substr(8);

               return {
                  fields: acc.fields,
                  userFields: [...acc.userFields, { values, selectType, path }],
               };
            }

            return {
               fields: { ...acc.fields, [`${key}_list`]: { values, selectType } },
               userFields: acc.userFields,
            };
         },
         { fields: {} as { [key: string]: ValueList }, userFields: [] as UserField[] },
      );

      return {
         ...fields,
         userFieldList: userFields,
      };
   }
}
