import { AbstractLanguage } from '@yandex-infracloud-ui/query-input';
import { languages } from 'monaco-editor/esm/vs/editor/editor.api';

class KeyValueLanguage extends AbstractLanguage {
   public static conf: languages.LanguageConfiguration = {
      autoClosingPairs: [{ open: '"', close: '"' }],
      surroundingPairs: [{ open: '"', close: '"' }],
   };

   public static language = {
      defaultToken: '',

      customkey: [
         // 'message',
         // 'context',
      ],

      contextkey: /context[\w\s\\.-]+/, // #DEPLOY-5864

      tokenizer: {
         root: [
            // keys
            [/context[\w\s\\.-]+/, 'customkey'], // #DEPLOY-5864
            [
               /(^[\w.]+)(\s*)([!]?=)/,
               [
                  {
                     cases: {
                        '@customkey': 'customkey',
                        '@default': 'key',
                     },
                  },
                  '',
                  'operator',
               ],
            ],

            // whitespace
            { include: '@whitespace' },
         ],

         whitespace: [[/\s+/, '']],
      },
   } as languages.IMonarchLanguage;

   constructor() {
      super('logs-key-value', KeyValueLanguage.language, KeyValueLanguage.conf);
   }
}

export const lang = new KeyValueLanguage();
