import React from 'react';

import { DeepPartial } from '../../../models';
import { TDockerRelease } from '../../../proto-typings';
import classes from './DockerResources.module.css';

interface Props {
   docker: DeepPartial<TDockerRelease>;
}

const defaultRegistry = 'registry.yandex.net';

export const DockerResources: React.FC<Props> = React.memo(({ docker }) => {
   const { images, registry, image_tag, image_name, image_hash } = docker;

   if (!images && !image_tag) {
      return null;
   }

   // TODO: было бы здорово перевести на облачный <Table>, но тут кастомный Old format с colSpan
   return (
      <table className={classes.resourcesTable}>
         <thead>
            <tr>
               <th>Docker image</th>
               <th>Hash</th>
            </tr>
         </thead>
         <tbody>
            {(images ?? []).map(image => (
               <tr key={image.digest}>
                  <td>{`${image.registry_host ?? defaultRegistry}/${image.name}:${image.tag}`}</td>
                  <td>{image.digest}</td>
               </tr>
            ))}
            {image_tag && (
               <>
                  <tr>
                     <td colSpan={2}>Old format</td>
                  </tr>
                  <tr>
                     <td>{`${registry ?? defaultRegistry}/${image_name}:${image_tag}`}</td>
                     <td>{image_hash}</td>
                  </tr>
               </>
            )}
         </tbody>
      </table>
   );
});

DockerResources.displayName = 'DockerResources';
