import React from 'react';

import { ReleaseObjectStatus, RELEASE_STATUS_NAMES } from '../../../models/ui';
import { Status, StatusState } from '../../lib';

interface Props {
   status: ReleaseObjectStatus;
   isAnimated?: boolean;
}

const statusMap: Partial<Record<ReleaseObjectStatus, StatusState>> = {
   [ReleaseObjectStatus.Created]: StatusState.Planned,
   [ReleaseObjectStatus.Open]: StatusState.Planned,
   [ReleaseObjectStatus.InProgress]: StatusState.Progress,
   [ReleaseObjectStatus.Pending]: StatusState.Progress,
   [ReleaseObjectStatus.Closed]: StatusState.Ok,
   [ReleaseObjectStatus.Unknown]: StatusState.Unknown,
};

export const ReleaseStatus: React.FC<Props> = React.memo(({ status, isAnimated = true, children }) => (
   <Status state={statusMap[status] ?? StatusState.Unknown} isAnimated={isAnimated}>
      {children ?? RELEASE_STATUS_NAMES[status] ?? status}
   </Status>
));

ReleaseStatus.displayName = 'ReleaseStatus';
