import { Table as SimpleTable, withTableSorting } from '@yandex-cloud/uikit';
import { ExternalLink, Json, modalService, useDismounted } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';
import { takeUntil } from 'rxjs/operators';

import { LegoButton } from '../../../_lego';
import { DeepPartial, EXTERNAL_LINKS } from '../../../models';
import { TPodSandboxResource, TSandboxRelease } from '../../../proto-typings';
import { SimpleModal } from '../../lib';

const Table = withTableSorting(SimpleTable);

interface Props {
   sandbox: DeepPartial<TSandboxRelease>;
}

export const SandboxResources: React.FC<Props> = React.memo(({ sandbox }) => {
   const { resources } = sandbox;

   const dismounted = useDismounted();

   const showJson = useCallback(
      (resource: DeepPartial<TPodSandboxResource>) => {
         modalService
            .open(SimpleModal, {
               title: `Resource ${resource.resource_id}`,
               children: <Json obj={resource} />,
            })
            .pipe(takeUntil(dismounted))
            .subscribe();
      },
      [dismounted],
   );

   if (!resources) {
      return null;
   }

   return (
      <Table
         columns={[
            // todo: типизировать колонки
            { id: 'id', name: 'Id', meta: { sort: true } },
            { id: 'type', name: 'Type', meta: { sort: true } },
            { id: 'description', name: 'Description' },
            { id: 'json', name: 'Raw data' },
         ]}
         data={[...resources].map(resource => ({
            id: resource.resource_id && (
               <ExternalLink href={EXTERNAL_LINKS.sandboxResource(Number(resource.resource_id))}>
                  {resource.resource_id}
               </ExternalLink>
            ),
            type: resource.type,
            description: resource.description,
            json: <LegoButton onClick={() => showJson(resource)}>Json</LegoButton>,
         }))}
      />
   );
});

SandboxResources.displayName = 'SandboxResources';
