import React, { useCallback } from 'react';

import { takeUntil } from 'rxjs/operators';
import { Button } from '@yandex-cloud/uikit';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faTools } from '@fortawesome/pro-regular-svg-icons';
import { modalService, useDismounted } from '@yandex-infracloud-ui/libs';

import { SimpleModal } from '../../lib';
import { UISettingsList } from './UISettingsList';

import classes from './UISettings.module.css';

export const UISettings: React.FC = () => {
   const dismounted = useDismounted();
   const openSettingsModal = useCallback(() => {
      modalService
         .open(
            SimpleModal,
            { title: 'UI Developer settings', children: <UISettingsList /> },
            {
               dialogProps: { size: 's' },
            },
         )
         .pipe(takeUntil(dismounted))
         .subscribe();
   }, [dismounted]);

   return (
      <div className={classes.settingsIcon}>
         <Button onClick={openSettingsModal} view={'flat'}>
            <FontAwesomeIcon icon={faTools} />
         </Button>
      </div>
   );
};
