import React, { useState } from 'react';

import { Checkbox } from '@yandex-cloud/uikit';

import { useForceRender } from '../../../utils';
import { Config, useConfig } from '../../../services';
import { configStorage } from '../../../services/Config';

import classes from './UISettingsList.module.css';

const reloadWarning = <div>The page needs to be reloaded</div>;

export const UISettingsList: React.FC = () => {
   const forceRender = useForceRender();
   const config = useConfig()!;
   const [isTestMode, setTestMode] = useState(document.body.classList.contains('developer-test-mode'));

   return (
      <div>
         <p className={classes.setting}>
            <Checkbox
               className={classes.label}
               checked={Config.isDeployAdmin()}
               onUpdate={value => {
                  configStorage.setItem('is-deploy-admin', value);
                  forceRender();
               }}
            >
               Deploy Admin
            </Checkbox>
            {reloadWarning}
            <pre>localStorage['is-deploy-admin']</pre>
         </p>

         <p className={classes.setting}>
            <Checkbox
               className={classes.label}
               checked={isTestMode}
               onUpdate={value => {
                  document.body.classList.toggle('developer-test-mode');
                  setTestMode(value);
               }}
            >
               Test mode
            </Checkbox>
            <pre>body.developer-test-mode</pre>
         </p>

         <p className={classes.setting}>
            <Checkbox
               className={classes.label}
               checked={config.isStageAllowEditAny()}
               onUpdate={value => {
                  configStorage.setItem('stages.allowEditAny', value);
                  forceRender();
               }}
            >
               Allow edit any stage
            </Checkbox>
            {reloadWarning}
            <pre>localStorage['stages.allowEditAny']</pre>
         </p>
      </div>
   );
};
