import React, { useCallback } from 'react';

import { takeUntil } from 'rxjs/operators';
import { Button } from '@yandex-cloud/uikit';
import { faCog } from '@fortawesome/pro-solid-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { modalService, useDismounted } from '@yandex-infracloud-ui/libs';

import { SimpleModal } from '../../lib';
import { UserSettingsList } from './UserSettingsList';

import classes from './UserSettings.module.css';

export const UserSettings: React.FC = () => {
   const dismounted = useDismounted();
   const openSettingsModal = useCallback(() => {
      modalService
         .open(
            SimpleModal,
            { title: 'User settings', children: <UserSettingsList /> },
            {
               dialogProps: { size: 's' },
            },
         )
         .pipe(takeUntil(dismounted))
         .subscribe();
   }, [dismounted]);

   return (
      <div className={classes.settingsIcon}>
         <Button onClick={openSettingsModal} view={'flat'}>
            <FontAwesomeIcon icon={faCog} />
         </Button>
      </div>
   );
};
