import React from 'react';

import { Checkbox } from '@yandex-cloud/uikit';

import { useForceRender } from '../../../utils';
import { useConfig } from '../../../services';
import { Config, configStorage } from '../../../services/Config';

import classes from './UserSettingsList.module.css';

const reloadWarning = <div>The page needs to be reloaded</div>;

export const UserSettingsList: React.FC = () => {
   const forceRender = useForceRender();
   const config = useConfig()!;

   return (
      <div>
         <p className={classes.setting}>
            <Checkbox
               className={classes.label}
               checked={config.isShowNewLogs()}
               onUpdate={value => {
                  if (value) {
                     Config.ym({ method: 'reachGoal', goal: 'show-new-logs' });
                  } else {
                     Config.ym({ method: 'reachGoal', goal: 'hide-new-logs' });
                  }

                  configStorage.setItem('stages.showNewLogs', value);
                  forceRender();
               }}
            >
               New logs <span style={{ color: 'var(--yc-color-infographics-danger-heavy)' }}>&nbsp;&beta;</span>
            </Checkbox>
            {reloadWarning}
         </p>
      </div>
   );
};
