import { action } from '@storybook/addon-actions';
import { select } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { DevJson, omitFields } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { RouteComponentProps } from 'react-router-dom';

import { StageConverter } from '../../models/ui';
import {
   apiServicesContextDecorator,
   configContextDecorator,
   modalsSupportDecorator,
   routerDecorator,
   RouteRenderer,
   stageHugeFormStage,
} from '../../stories';
import { StageHugeFormMode } from './models';
import { StageHugeForm } from './StageHugeForm';

// eslint-disable-next-line @typescript-eslint/no-var-requires
const Story = (props: RouteComponentProps<{ stageId: string }>) => (
   <div style={{ '--header-height': 0 } as any}>
      <DevJson summary={'location.pathname'} open={true}>
         {props.location?.pathname ?? ''}
      </DevJson>

      <StageHugeForm
         rawStage={stageHugeFormStage}
         mode={select(
            'mode',
            [
               StageHugeFormMode.Apply,
               StageHugeFormMode.ApplyAsIs,
               StageHugeFormMode.Edit,
               StageHugeFormMode.New,
               StageHugeFormMode.View,
            ],
            StageHugeFormMode.Edit,
         )}
         onCancel={action('onCancel')}
      >
         {({ content }) => <>{content}</>}
      </StageHugeForm>
   </div>
);

export const FormPage = () => (
   <RouteRenderer
      path={'/stages/:projectId/edit'}
      url={`/stages/${stageHugeFormStage.meta!.id}/edit`}
      component={Story}
   />
);

export const Model = () => (
   <DevJson open={true}>
      {omitFields(StageConverter.fromApi(stageHugeFormStage), 'dockerTargets', 'sandboxTargets')}
   </DevJson>
);

export const RawModel = () => <DevJson open={true}>{stageHugeFormStage}</DevJson>;

export default {
   decorators: [routerDecorator, configContextDecorator, apiServicesContextDecorator, modalsSupportDecorator],
   title: 'components/stage-huge-form/StageHugeForm',
} as Meta;
