import { DISMISS_REASON, IModalProps, ModalLayout } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';

import classes from '../../../../design/commonModals.module.css';
import { LegoButton } from '../../../../_lego';

export const ReloadStageModal: React.FC<IModalProps<boolean>> = React.memo(({ ok, cancel }) => {
   const handleOk = useCallback(reload => () => ok(reload), [ok]);
   const handleDismiss = useCallback(() => cancel(DISMISS_REASON), [cancel]);

   return (
      <ModalLayout
         title={'Stage specification has been updated'}
         onDismiss={handleDismiss}
         onOk={handleOk}
         showFooter={false}
      >
         <footer className={classes.footer}>
            <LegoButton cls={classes.button} onClick={handleDismiss}>
               Cancel
            </LegoButton>

            <LegoButton cls={classes.button} onClick={handleOk(false)}>
               Continue with current spec
            </LegoButton>

            <LegoButton theme={'action'} cls={classes.button} onClick={handleOk(true)}>
               Reload spec and continue
            </LegoButton>
         </footer>
      </ModalLayout>
   );
});

ReloadStageModal.displayName = 'ReloadStageModal';
