import { HelpPopover } from '@yandex-cloud/uikit';
import { ExternalLink, WarningPlate } from '@yandex-infracloud-ui/libs';
import React, { useContext } from 'react';

import { EXTERNAL_LINKS } from '../../../../models';
import { defaultPatcherRevision, SidecarName } from '../../../../models/ui';
import { ResourcesContext } from '../../../../models/ui/stage/resources';
import { ResourceGroup, resourcesModel } from '../../../../modules/resources/config';

// !!!
import { useSidecarResources } from '../../hooks/useSidecarResources';

interface Props {
   sidecar: SidecarName;
   deployUnit: string;
   box?: string;
   workload?: string;
}

export const SidecarResourcePlate: React.FC<Props> = React.memo(({ sidecar, deployUnit, box = '', workload = '' }) => {
   const { resources = {}, diskType } = useSidecarResources({ sidecar, deployUnit, box, workload });
   const { stagePatcherRevisions } = useContext(ResourcesContext);
   const patcherRevision = stagePatcherRevisions[deployUnit] ?? defaultPatcherRevision;

   if (Object.values(resources).every(e => e === 0)) {
      return null;
   }

   return (
      <WarningPlate>
         Enabled {sidecar} agent will rise the requested resources
         <HelpPopover
            content={
               <>
                  Resource values for runtime version <b>{patcherRevision}</b>
                  <br />
                  <ExternalLink href={EXTERNAL_LINKS.deployDocs.sidecarQuota}>documentaion</ExternalLink>
               </>
            }
         />
         <br />
         <b>
            {([ResourceGroup.Cpu, ResourceGroup.Mem, ResourceGroup.Disk] as const).map((resourceGroup, i) => {
               const value = resources[resourceGroup] ?? 0;
               if (value === 0) {
                  return null;
               }
               const {
                  resource: { getValueView },
                  groupTitle,
               } = resourcesModel[resourceGroup]!;
               return (
                  <span key={resourceGroup}>
                     {i > 0 && ', '}+{getValueView(value)} of {groupTitle}
                     {resourceGroup === ResourceGroup.Disk && diskType && <span>({diskType.toUpperCase()})</span>}
                  </span>
               );
            })}{' '}
            per Pod
         </b>
      </WarningPlate>
   );
});

SidecarResourcePlate.displayName = 'SidecarResourcePlate';
