import { action } from '@storybook/addon-actions';
import { Meta } from '@storybook/react';
import React from 'react';

import { DeepPartial } from '../../../../models';
import { Stage } from '../../../../models/ui';
import { EObjectType, TStage } from '../../../../proto-typings';
import { apiServicesContextDecorator } from '../../../../stories';
import { StageHugeFormMode } from '../../models';

import { StageDiffView } from './StageDiffView';

const formValue: Stage = {
   id: 'new_stage',
   project: { id: 'test_project', accountId: 'abc:service:3443' },
   soxService: false,
   deployUnits: [],
   dockerTargets: [],
   sandboxTargets: [],
   infra: {
      service: { id: null, name: null },
      environment: { id: null, name: null },
   },
   labels: {},
   revision: undefined,
   revisionDescription: null,
};

const specValue: DeepPartial<TStage> = {
   annotations: {},
   labels: {},
   meta: {
      acl: [],
      creation_time: new Date().getTime(),
      id: 'old_stage',
      inherit_acl: false,
      name: 'old_stage',
      project_id: 'test_project',
      type: EObjectType.OT_STAGE,
      uuid: 'xxxx',
      account_id: 'string',
      effective_account_id: 'string',
   },
   status: undefined,
   spec: {
      revision: 1,
      deploy_units: {},
      account_id: 'ssss',
      revision_info: { description: 'release notes' },
      dynamic_resources: {},
      sox_service: false,
      resource_caches: {},
   },
};

export const Regular = () => (
   <StageDiffView
      duConfirmations={{}}
      isApprovalRequired={false}
      latestRawStage={undefined}
      mode={StageHugeFormMode.Edit}
      onCancel={action('onCancel')}
      onDeploy={action('onDeploy')}
      onDeployDraft={action('onDeployDraft')}
      specValue={specValue as TStage}
      value={formValue}
   />
);

export default {
   decorators: [apiServicesContextDecorator],
   title: 'pages/stages/StageDiffView',
} as Meta;
