import React from 'react';

import {
   ChangeValidateParams,
   MonacoEditorStatusLine,
   MonacoEditorValidationInfo,
   YamlEditor,
} from '@yandex-infracloud-ui/monaco-editor';

import { useJSONSchemaByPath } from '../../../../json-schema';

import classes from './StageHugeYamlEditor.module.css';

interface Props {
   value: string;
   readonly?: boolean;
   validationInfo?: MonacoEditorValidationInfo | null;
   onUpdate?(value: string): void;
   onChangeValidate?(params: ChangeValidateParams): void;
}

export const StageHugeYamlEditor: React.FC<Props> = React.memo(
   ({ value, onUpdate, readonly, onChangeValidate, validationInfo }) => {
      useJSONSchemaByPath('/yp/TStage');

      return (
         <div>
            <YamlEditor
               value={value}
               onUpdate={readonly ? undefined : onUpdate}
               onChangeValidate={onChangeValidate}
               uri={'https://deploy.yandex-team.ru/yp/TStage'}
               className={classes.yamlEditor}
               isAutoRows={true}
               placeholder={'input stage data'}
            />
            <MonacoEditorStatusLine validationInfo={validationInfo ?? null} />
         </div>
      );
   },
);

StageHugeYamlEditor.displayName = 'StageHugeYamlEditor';
